% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_garch.R
\name{hanr_garch}
\alias{hanr_garch}
\title{Anomaly detector using GARCH}
\usage{
hanr_garch()
}
\value{
\code{hanr_garch} object
}
\description{
Anomaly detection using GARCH
The GARCH model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the ugarch model presented in the rugarch library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series regression model
model <- hanr_garch()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
