% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Etheta_imaginary}
\alias{Etheta_imaginary}
\title{Incomplete gamma function of imaginary argument with arbitrary power}
\usage{
Etheta_imaginary(theta, x)
}
\arguments{
\item{theta}{A strictly positive number}

\item{x}{A vector of non-negative numbers}
}
\value{
The incomplete gamma function of imaginary argument with arbitrary power (see Details)
}
\description{
Calculates the value of
\deqn{-ix e^{ix} E_\theta(ix) = -ix e{ix} \int_1^\infty t^{-\theta} e^{-ixt} \mathrm d t}
for \eqn{\theta > 0}.
This is achieved using recursive integrations by parts until \eqn{0 < \theta \le 1},
then using either the exponential integral \code{E1_imaginary} if \eqn{\theta = 1},
or the incomplete gamma function \code{inc_gamma_imag} if \eqn{0 < \theta < 1}.
}
\examples{
Etheta_imaginary(3.14, 1.0)
}
