% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbamr-package.R
\docType{package}
\name{hbamr-package}
\alias{hbamr-package}
\alias{hbamr}
\title{Hierarchical Bayesian Aldrich-McKelvey Scaling via Stan}
\description{
Fit hierarchical Bayesian Aldrich-McKelvey (HBAM) models using a form of Hamiltonian Monte Carlo via Stan. Aldrich-McKelvey (AM) scaling is a method for estimating the ideological positions of survey respondents and political actors on a common scale using positional survey data. The hierarchical versions of the Bayesian AM model included in this package outperform other versions by a considerable margin both in terms of yielding meaningful posterior distributions for respondent positions and in terms of recovering true respondent positions in simulations. The package contains functions for preparing data, fitting models, extracting estimates, plotting key results, and comparing models using cross-validation.
}
\references{
\itemize{
\item Bølstad, Jørgen (forthcoming). Hierarchical Bayesian Aldrich-McKelvey Scaling. \if{html}{\out{<i>}}Political Analysis\if{html}{\out{</i>}}.
\item Stan Development Team (2023). RStan: the R interface to Stan. R package version 2.21.8. https://mc-stan.org
}
}
\seealso{
\itemize{\item \url{https://github.com/jbolstad/hbamr/}}
}
\author{
Jørgen Bølstad
}
