% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWINS_data_frame.R
\name{calcWINS.data.frame}
\alias{calcWINS.data.frame}
\title{Win statistics calculation using a data frame}
\usage{
\method{calcWINS}{data.frame}(x, AVAL, TRTP, ref, alpha = 0.05, WOnull = 1, ...)
}
\arguments{
\item{x}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{ref}{the reference treatment group.}

\item{alpha}{2-sided significance level. The default is 0.05.}

\item{WOnull}{the null hypothesis. The default is 1.}

\item{...}{additional parameters.}
}
\value{
a list containing win statistics and their confidence intervals. It contains the following named data frames:
\itemize{
\item summary a data frame containing number of wins, losses, and ties of the active treatment group and the overall number of comparisons.
\item WP a data frame containing the win probability and its confidence interval.
\item NetBenefit a data frame containing the net benefit and its confidence interval. This is just a \verb{2x-1} transformation of WP and its CI.
\item WO a data frame containing the win odds and its confidence interval.
\item WR1 a data frame containing the win ratio and its confidence interval, using the transformed standard error of the \code{gamma} statistic.
\item WR2 a data frame containing the win ratio and its confidence interval, using the standard error calculated using \code{Pties}.
\item gamma a data frame containing Goodman Kruskal's \code{gamma} and its confidence interval.
\item SE a data frame containing standard errors used to calculed the Confidence intervals for win statistics.
}
}
\description{
Win statistics calculation using a data frame
}
\examples{
calcWINS(x = COVID19b, AVAL = "GROUP", TRTP = "TRTP", ref = "P")
}
\references{
The theory of win statistics is covered in the following papers.
\itemize{
\item For the win proportion CI calculation see
\cr \cr Gasparyan, Samvel B., et al. "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2 (2021): 580-611 \url{doi:10.1177/0962280220942558}.
\item The win odds CI is calculated using the formula in
\cr \cr Gasparyan, Samvel B., et al. "Power and sample size calculation for the win odds test: application to an ordinal endpoint in COVID-19 trials." Journal of Biopharmaceutical Statistics 31.6 (2021): 765-787 \url{doi:10.1080/10543406.2021.1968893}.
\item The win ratio the first CI uses the standard error derived from the standard error of the \code{gamma} statistic.
\item The win ratio the second CI uses the standard error presented in
\cr \cr Yu RX, Ganju J. Sample size formula for a win ratio endpoint. Statistics in medicine. 2022 Mar 15;41(6):950-63 \url{doi:10.1002/sim.9297}.
\item The Goodman Kruskal's \code{gamma} and its CI match those in DescTools::GoodmanKruskalGamma() and are based on
\cr \cr Agresti, A. (2002) Categorical Data Analysis. John Wiley & Sons, pp. 57-59.
\cr \cr Brown, M.B., Benedetti, J.K.(1977) Sampling Behavior of Tests for Correlation in Two-Way Contingency Tables, Journal of the American Statistical Association, 72, 309-315.
\cr \cr Goodman, L. A., & Kruskal, W. H. (1954) Measures of association for cross classifications. Journal of the American Statistical Association, 49, 732-764.
\cr \cr Goodman, L. A., & Kruskal, W. H. (1963) Measures of association for cross classifications III: Approximate sampling theory. Journal of the American Statistical Association, 58, 310-364.
}
}
\seealso{
\code{\link[=calcWINS]{calcWINS()}}, \code{\link[=calcWINS.hce]{calcWINS.hce()}}, \code{\link[=calcWINS.formula]{calcWINS.formula()}}.
}
