% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeWO.R
\name{sizeWO}
\alias{sizeWO}
\title{Sample size calculation for the win odds test (no ties)}
\usage{
sizeWO(WO, power, SD = NULL, k = 0.5, alpha = 0.05, WOnull = 1)
}
\arguments{
\item{WO}{a numeric vector of win odds values.}

\item{power}{the given power. A numeric vector of length 1.}

\item{SD}{assumed standard deviation of the win proportion. By default uses the conservative SD. A numeric vector of length 1.}

\item{k}{proportion of active group in the overall sample size. Default is 0.5 (balanced randomization). A numeric vector of length 1.}

\item{alpha}{the significance level for the 2-sided test. Default is 0.05. A numeric vector of length 1.}

\item{WOnull}{the win odds value of the null hypothesis (default is 1). A numeric vector of length 1.}
}
\value{
a data frame containing the sample size with input values.
}
\description{
Sample size calculation for the win odds test (no ties)
}
\examples{
sizeWO(WO = 1.25, power = 0.9)
sizeWO(WO = 1.25, power = 0.9, k = 0.75)
sizeWO(WO = seq(1.05, 1.5, 0.05), power = 0.9)
}
\references{
Gasparyan SB et al. (2021) "Power and sample size calculation for the win odds test: application to an ordinal endpoint in COVID-19 trials." Journal of Biopharmaceutical Statistics 31.6: 765-787. \url{doi:10.1080/10543406.2021.1968893}.
}
\seealso{
\code{\link[=powerWO]{powerWO()}}, \code{\link[=minWO]{minWO()}} for WO power or minimum detectable WO calculation.
}
