// (c) The HDF Group
#ifndef H5Gpublic_H
#define H5Gpublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#include "H5Lpublic.h"
#include "H5Opublic.h"
//! <!-- [H5G_storage_t_snip] -->
typedef enum H5G_storage_type_t {
    H5G_STORAGE_TYPE_UNKNOWN = -1,
    H5G_STORAGE_TYPE_SYMBOL_TABLE,
    H5G_STORAGE_TYPE_COMPACT,
    H5G_STORAGE_TYPE_DENSE
} H5G_storage_type_t;
//! <!-- [H5G_storage_t_snip] -->
//! <!-- [H5G_info_t_snip] -->
typedef struct H5G_info_t {
    H5G_storage_type_t storage_type;
    hsize_t            nlinks;
    int64_t            max_corder;
    hbool_t            mounted;
} H5G_info_t;
//! <!-- [H5G_info_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5Gcreate2(hid_t loc_id, const char *name, hid_t lcpl_id, hid_t gcpl_id, hid_t gapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Gcreate_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                             const char *name, hid_t lcpl_id, hid_t gcpl_id, hid_t gapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Gcreate_async(hid_t loc_id, const char *name, hid_t lcpl_id, hid_t gcpl_id, hid_t gapl_id,
                             hid_t es_id);
#endif
H5_DLL hid_t H5Gcreate_anon(hid_t loc_id, hid_t gcpl_id, hid_t gapl_id);
H5_DLL hid_t H5Gopen2(hid_t loc_id, const char *name, hid_t gapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Gopen_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                           const char *name, hid_t gapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Gopen_async(hid_t loc_id, const char *name, hid_t gapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Gget_create_plist(hid_t group_id);
H5_DLL herr_t H5Gget_info(hid_t loc_id, H5G_info_t *ginfo);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Gget_info_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                                H5G_info_t *ginfo, hid_t es_id);
#else
H5_DLL herr_t H5Gget_info_async(hid_t loc_id, H5G_info_t *ginfo, hid_t es_id);
#endif
H5_DLL herr_t H5Gget_info_by_name(hid_t loc_id, const char *name, H5G_info_t *ginfo, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Gget_info_by_name_async(const char *app_file, const char *app_func, unsigned app_line,
                                        hid_t loc_id, const char *name, H5G_info_t *ginfo,
                                        hid_t lapl_id, hid_t es_id);
#else
H5_DLL herr_t H5Gget_info_by_name_async(hid_t loc_id, const char *name, H5G_info_t *ginfo,
                                        hid_t lapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Gget_info_by_idx(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                 H5_iter_order_t order, hsize_t n, H5G_info_t *ginfo, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Gget_info_by_idx_async(const char *app_file, const char *app_func, unsigned app_line,
                                       hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                       H5_iter_order_t order, hsize_t n, H5G_info_t *ginfo,
                                       hid_t lapl_id, hid_t es_id);
#else
H5_DLL herr_t H5Gget_info_by_idx_async(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                       H5_iter_order_t order, hsize_t n, H5G_info_t *ginfo,
                                       hid_t lapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Gflush(hid_t group_id);
H5_DLL herr_t H5Grefresh(hid_t group_id);
H5_DLL herr_t H5Gclose(hid_t group_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Gclose_async(const char *app_file, const char *app_func, unsigned app_line, hid_t group_id,
                             hid_t es_id);
#else
H5_DLL herr_t H5Gclose_async(hid_t group_id, hid_t es_id);
#endif
/// \cond DEV
#ifndef H5G_MODULE
#define H5Gcreate_async(...)           H5Gcreate_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Gopen_async(...)             H5Gopen_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Gget_info_async(...)         H5Gget_info_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Gget_info_by_name_async(...) H5Gget_info_by_name_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Gget_info_by_idx_async(...)  H5Gget_info_by_idx_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Gclose_async(...)            H5Gclose_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Gcreate_async_wrap           H5_NO_EXPAND(H5Gcreate_async)
#define H5Gopen_async_wrap             H5_NO_EXPAND(H5Gopen_async)
#define H5Gget_info_async_wrap         H5_NO_EXPAND(H5Gget_info_async)
#define H5Gget_info_by_name_async_wrap H5_NO_EXPAND(H5Gget_info_by_name_async)
#define H5Gget_info_by_idx_async_wrap  H5_NO_EXPAND(H5Gget_info_by_idx_async)
#define H5Gclose_async_wrap            H5_NO_EXPAND(H5Gclose_async)
#endif
/// \endcond
#ifndef H5_NO_DEPRECATED_SYMBOLS
#define H5G_SAME_LOC   H5L_SAME_LOC
#define H5G_LINK_ERROR H5L_TYPE_ERROR
#define H5G_LINK_HARD  H5L_TYPE_HARD
#define H5G_LINK_SOFT  H5L_TYPE_SOFT
#define H5G_link_t     H5L_type_t
#define H5G_NTYPES      256
#define H5G_NLIBTYPES   8
#define H5G_NUSERTYPES  (H5G_NTYPES - H5G_NLIBTYPES)
#define H5G_USERTYPE(X) (8 + (X))
//! <!-- [H5G_obj_t_snip] -->
typedef enum H5G_obj_t {
    H5G_UNKNOWN = -1,
    H5G_GROUP,
    H5G_DATASET,
    H5G_TYPE,
    H5G_LINK,
    H5G_UDLINK,
    H5G_RESERVED_5,
    H5G_RESERVED_6,
    H5G_RESERVED_7
} H5G_obj_t;
//! <!-- [H5G_obj_t_snip] -->
//! <!-- [H5G_iterate_t_snip] -->
typedef herr_t (*H5G_iterate_t)(hid_t group, const char *name, void *op_data);
//! <!-- [H5G_iterate_t_snip] -->
//! <!-- [H5G_stat_t_snip] -->
typedef struct H5G_stat_t {
    unsigned long fileno[2];
    unsigned long objno[2];
    unsigned      nlink;
    H5G_obj_t     type;
    time_t        mtime;
    size_t        linklen;
    H5O_stat_t    ohdr;
} H5G_stat_t;
//! <!-- [H5G_stat_t_snip] -->
H5_DLL hid_t H5Gcreate1(hid_t loc_id, const char *name, size_t size_hint);
H5_DLL hid_t H5Gopen1(hid_t loc_id, const char *name);
H5_DLL herr_t H5Glink(hid_t cur_loc_id, H5G_link_t type, const char *cur_name, const char *new_name);
H5_DLL herr_t H5Glink2(hid_t cur_loc_id, const char *cur_name, H5G_link_t type, hid_t new_loc_id,
                       const char *new_name);
H5_DLL herr_t H5Gmove(hid_t src_loc_id, const char *src_name, const char *dst_name);
H5_DLL herr_t H5Gmove2(hid_t src_loc_id, const char *src_name, hid_t dst_loc_id, const char *dst_name);
H5_DLL herr_t H5Gunlink(hid_t loc_id, const char *name);
H5_DLL herr_t H5Gget_linkval(hid_t loc_id, const char *name, size_t size, char *buf);
H5_DLL herr_t H5Gset_comment(hid_t loc_id, const char *name, const char *comment);
H5_DLL int H5Gget_comment(hid_t loc_id, const char *name, size_t bufsize, char *buf);
H5_DLL herr_t H5Giterate(hid_t loc_id, const char *name, int *idx, H5G_iterate_t op, void *op_data);
H5_DLL herr_t H5Gget_num_objs(hid_t loc_id, hsize_t *num_objs);
H5_DLL herr_t H5Gget_objinfo(hid_t loc_id, const char *name, hbool_t follow_link,
                             H5G_stat_t *statbuf);
H5_DLL ssize_t H5Gget_objname_by_idx(hid_t loc_id, hsize_t idx, char *name, size_t size);
H5_DLL H5G_obj_t H5Gget_objtype_by_idx(hid_t loc_id, hsize_t idx);
#endif
#ifdef __cplusplus
}
#endif
#endif
