% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5-functions.R
\name{h5GuessDtype}
\alias{h5GuessDtype}
\title{Guess an HDF5 Datatype}
\usage{
h5GuessDtype(x, stype = c("utf8", "ascii7"), ...)
}
\arguments{
\item{x}{The object for which to guess the HDF5 datatype}

\item{stype}{'utf8' or 'ascii7'}

\item{...}{Arguments passed to \code{hdf5r::guess_dtype}}
}
\value{
An object of class \code{\link[hdf5r]{H5T}}
}
\description{
Wrapper around \code{\link[hdf5r:guess_nelem]{hdf5r::guess_dtype}}, allowing 
for the customization of string types such as utf-8 rather than defaulting to 
variable-length ASCII-encoded strings.
}
\examples{
h5GuessDtype(0)
h5GuessDtype("abc")

}
\references{
\url{https://github.com/mojaveazure/seurat-disk/blob/163f1aade5bac38ed1e9e9c9
12283a7e74781610/R/zzz.R}
}
\seealso{
\code{\link[hdf5r:guess_nelem]{guess_dtype}}
}
