% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_STRING-class}
\alias{H5T_STRING-class}
\alias{H5T_STRING}
\title{Class for HDF5 string datatypes.}
\value{
Object of class \code{\link[=H5T_STRING]{H5T_STRING}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}.
}
\section{Methods}{

\describe{
\item{\code{new(type = c("c", "fortran"), size = 1, id = NULL)}}{

Create a string datatype

\strong{Parameters}
\describe{
\item{A}{C or fortran type string}
\item{size}{Size of the string object. Set to \code{Inf} for variable size strings}
\item{id}{internal use only}
}}

\item{\code{get_size(variable_as_inf = TRUE)}}{

Retrieves the length of the string, setting it to \code{Inf} it is of variable length.
This function implements the HDF5-API function H5Tis_variable_str.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-IsVariableStr} for details.}

\item{\code{get_cset()}}{

This function implements the HDF5-API function H5Tget_cset.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-GetCset} for details.}

\item{\code{set_cset(cset = c("unknown", "UTF-8"))}}{

This function implements the HDF5-API function H5Tset_cset.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-SetCset} for details.}

\item{\code{set_strpad(strpad)}}{

This function implements the HDF5-API function H5Tset_strpad.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-SetStrpad} for details.}

\item{\code{get_strpad()}}{

This function implements the HDF5-API function H5Tget_strpad.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-GetStrpad} for details.}

\item{\code{describe()}}{

Print a detailed description of the datatype; this is experimental}
}}

\examples{
# fixed width string
str_flen <- H5T_STRING$new(size=100)
str_flen$is_vlen()
str_flen

# variable length string
str_vlen <- H5T_STRING$new(size=Inf)
str_vlen$is_vlen()
str_vlen
}
\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
