% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdmm.R
\name{mediate_hdmm}
\alias{mediate_hdmm}
\title{High-dimensional Multivariate Mediation Analysis with
Principal Directions of Mediation}
\source{
\url{https://github.com/oliverychen/PDM}
}
\usage{
mediate_hdmm(
  A,
  M,
  Y,
  sims = 1000,
  boot_ci_type = "bca",
  ci_level = 0.95,
  tol = 10^-5,
  theta = rep(1, 5),
  w1 = rep(1, ncol(M)),
  interval = 10^6,
  step = 10^4,
  imax = 100
)
}
\arguments{
\item{A}{numeric vector containing exposure variable.}

\item{M}{numeric matrix of high-dimensional mediators. It is not recommended
to supply a matrix with more mediators than observations.}

\item{Y}{numeric vector containing continuous outcome variable.}

\item{sims}{number of Monte Carlo draws for nonparametric bootstrap or
quasi-Bayesian approximation. See \code{\link{mediate}}. Default is 1000.}

\item{boot_ci_type}{a character string indicating the type of bootstrap
confidence intervals for when \code{boot = TRUE}. If \code{"bca"},
bias-corrected and accelerated (BCa) confidence intervals will be estimated.
If \code{"perc"}, percentile confidence intervals will be estimated
(see \code{\link[mediation:mediate]{mediation::mediate()}}). Default is "bca".}

\item{ci_level}{the designated confidence level. Default 0.95.}

\item{tol}{tolerance. Default 10^-5.}

\item{theta}{numeric vector of length 5 describing starting value of pathway
coefficients. Default is a vector of 1's.}

\item{w1}{numeric vector of the same length of \code{A} specifying PDM
starting values. Default is a vector of 1's.}

\item{interval}{numeric vector proportional to the intervals from where the
smoothing parameter is searched. Default is 10^6.}

\item{step}{numerical number specifying step width for smoothing parameter
search. Default is 10^4.}

\item{imax}{integer specifying the maximum number of iterations allowed.
Default is 100.}
}
\value{
A list containing:
\itemize{
\item{pdm: }{the first direction of mediation by which mediators are
weighted.}
\item{mediator: }{the latent mediator corresponding to the first direction
of mediation.}
\item{effects: }{a data frame containing the estimates, confidence
intervals, and p-values of the mediation effects.}
}
}
\description{
\code{mediate_hdmm} estimates the first  "direction of mediation" in the
causal mediation mechanism of an exposure \code{A}, an outcome \code{Y}, and high-dimensional
mediators \code{M} as proposed by Chén et al. (2018).
}
\details{
HDMM provides latent variable approach to high-dimensional mediation analysis.
The function \code{mediate_hdmm} uses a likelihood-based approach to compute
principal directions of mediation (PDMs), which are loading weights used to linearly
combine the inputted mediators to form a single, latent variable that replaces
the original mediators in the analysis. Though HDMM cannot be used to estimate
the global mediation effect or the contributions of specific mediators, it can
still can be useful for inferring whether there is mediation occurring through
the set of mediators as a joint system. See the provided reference for more
details.
}
\examples{
A <- as.numeric(scale(med_dat$A)) # can help to standardize
M <- scale(med_dat$M[,1:8])
Y <- as.numeric(scale(med_dat$Y))

out <- mediate_hdmm(A, M, Y, sims = 5, tol = 10^-3, imax = 50)
out$effects

}
\references{
Chén, O. Y. et al. High-dimensional multivariate mediation with
application to neuroimaging data. Biostatistics 19, 121-136 (2018).
}
