% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.hdnom.models.R
\name{hdcox.mcp}
\alias{hdcox.mcp}
\title{MCP Model Selection for High-Dimensional Cox Models}
\usage{
hdcox.mcp(x, y, nfolds = 5L, gammas = c(1.01, 1.7, 3, 100), seed = 1001,
  trace = FALSE, parallel = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made by \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{gammas}{Gammas to tune in \code{\link[ncvreg]{cv.ncvsurv}}.}

\item{seed}{A random seed for cross-validation fold division.}

\item{trace}{Output the cross-validation parameter tuning
progress or not. Default is \code{FALSE}.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}
}
\description{
Automatic MCP model selection for high-dimensional
Cox models, evaluated by penalized partial-likelihood.
}
\examples{
library("survival")
library("rms")

# Load imputed SMART data; only use the first 150 samples
data("smart")
x = as.matrix(smart[, -c(1, 2)])[1:150, ]
time = smart$TEVENT[1:150]
event = smart$EVENT[1:150]
y = Surv(time, event)

# Fit Cox model by MCP penalization
mcpfit = hdcox.mcp(x, y, nfolds = 3, gammas = c(2.1, 3), seed = 1001)

# Prepare data for hdnom.nomogram
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(mcpfit$mcp_model, model.type = "mcp", x, time, event, x.df,
                     lambda = mcpfit$mcp_best_lambda, pred.at = 365 * 2,
                     funlabel = "2-Year Overall Survival Probability")
plot(nom)
}

