\name{lane}
\alias{lane2}
\alias{lane3}
\title{Speed-Flow data for Californian Freeway}
\description{These are two data sets collected in 1993 on two individual lanes
(lane 2 and lane 3) of the 4-lane Californian freeway I-880. The data were
collected by loop detectors, and the time units are 30 seconds per
observation (see Petty et al., 1996, for details).
}
\usage{
data(lane2)
data(lane3)
}

\format{
 Two data frames (\code{lane2} and \code{lane3}) each with 1318  observations
 on the following two variables:
  \describe{
    \item{\code{flow}}{a numeric vector giving the traffic flow in vehicles per lane per hour.}
    \item{\code{speed}}{a numeric vector giving the speed in miles per hour.}
}
}

\details{
The data is  examined in Einbeck and Tutz (2006), using a nonparametric approach
to multi-valued regression based on conditional mean shift.
}


\source{
Petty, K.F.,  Noeimi, H., Sanwal, K.,  Rydzewski, D., Skabardonis, A.,
Varaiya, P., and  Al-Deek, H.  (1996). ``The Freeway Service Patrol Evaluation Project:
Database Support Programs, and Accessibility''. \emph{Transportation Research Part C: Emerging
Technologies}, \bold{4}, 71-85.

The data is provided courtesy of CALIFORNIA PATH, Institute of Transportation Studies,
University of California, Berkeley.
}

\references{Einbeck, J., and Tutz, G. (2006). ``Modelling beyond regression functions:
 an application of multimodal regression to speed-flow data''. \emph{Applied Statistics},
 2006, in press.}

\keyword{datasets}
\examples{
plot(lane2$flow, lane2$speed)
}
