% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/headline.R
\name{headline}
\alias{headline}
\alias{headline_list}
\title{Compose phrases that describe differences in the data}
\usage{
headline(
  x,
  y,
  headline = "{trend} of {delta} ({orig_values})",
  ...,
  if_match = "There was no difference",
  trend_phrases = headliner::trend_terms(),
  plural_phrases = NULL,
  orig_values = "{x} vs. {y}",
  n_decimal = 1,
  round_all = TRUE,
  multiplier = 1,
  return_data = FALSE
)

headline_list(
  l,
  headline = "{trend} of {delta} ({orig_values})",
  x,
  y,
  ...,
  if_match = "There was no difference.",
  trend_phrases = headliner::trend_terms(),
  plural_phrases = NULL,
  orig_values = "{x} vs. {y}",
  n_decimal = 1,
  round_all = TRUE,
  multiplier = 1,
  return_data = FALSE
)
}
\arguments{
\item{x}{a numeric value to compare to the reference value of 'y'}

\item{y}{a numeric value to act as a control for the 'x' value}

\item{headline}{a string to format the final output. Uses
\code{\link[glue]{glue}} syntax}

\item{...}{arguments passed to \code{\link[glue]{glue_data}}}

\item{if_match}{string to display if numbers match, uses
\code{\link[glue]{glue}} syntax}

\item{trend_phrases}{list of values to use for when x is more than y
or x is less than y. You can pass it just
\code{\link{trend_terms}} (the default) and call the result with
\code{"...{trend}..."} or pass is a named list (see examples)}

\item{plural_phrases}{named list of values to use when difference (delta) is
singular (delta = 1) or plural (delta != 1)}

\item{orig_values}{a string using \code{\link[glue]{glue}} syntax.
example: \verb{(\{x\} vs \{y\})}}

\item{n_decimal}{numeric value to limit the number of decimal places in
the returned values.}

\item{round_all}{logical value to indicate if all values should be rounded.
When FALSE, the values will return with no modification. When TRUE (default)
all values will be round to the length specified by 'n_decimal'.}

\item{multiplier}{number indicating the scaling factor. When multiplier = 1
(default), 0.25 will return 0.25. When multiplier = 100, 0.25 will return 25.}

\item{return_data}{logical to indicate whether function should return the
talking points used to compose the headline}

\item{l}{a list with values to compare, if named, can call by name}
}
\value{
Returns a character vector the same length as the input,
}
\description{
Given two values, \code{headline()} will use
\code{\link[glue]{glue}} syntax to string together "talking points".
For example \code{headline(8, 10)} will describe a difference of 2 and can be
expressed as
\code{headline(8, 10, headline = "changed by {delta} ({raw_delta_p}\%)")}. This
returns "changed by 2 (-20\%)".
}
\details{
\code{headline()} relies heavily on \code{\link[glue]{glue_data}}.
Objects can be combined into a headline using the following search path:
If given

\if{html}{\out{<div class="sourceCode r">}}\preformatted{delta <- 123
headline(1, 3, delta = "abc")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## decrease of abc (1 vs. 3)
}\if{html}{\out{</div>}}

\code{delta} is one of the "talking points" from \code{compare_values()} and would
usually return "2" but because we passed the named variable
\code{delta = "none"}, \code{headline()} (really  \code{\link[glue]{glue_data}})
will look first at the named variables, then at the result of
\code{compare_values()} then in the global environment. So in the example above,
the output will return \code{"decrease of xxxxxx (1 vs. 3)"}
}
\examples{
# values can be manually entered, some headlines are provided by default
headline(10, 8)
headline(8, 10)
headline(1:3, 3:1)

# most likely you'll edit the headline by hand
headline(
  x = 10,
  y = 8,
  headline = "There was a ${delta} {trend} vs last year"
)

# you can also adjust the phrasing of higher/lower values
headline(
  x = 10,
  y = 8,
  headline = "Group A was {trend} by {delta_p}\%.",
  trend_phrases = trend_terms(more = "higher", less = "lower")
 )

# a phrase about the comparion can be edited by providing glue syntax
# 'c' = the 'compare' value, 'r' = 'reference'
headline(10, 8, orig_values = "{x} to {y} people")

# you can also add phrases for when the difference = 1 or not
headline(
  x = 10,
  y = 8,
  plural_phrases = list(
    were = plural_phrasing(single = "was", multi = "were"),
    people = plural_phrasing(single = "person", multi = "people")
  ),
  headline = "there {were} {delta} {people}"
)

# you can also adjust the rounding, the default is 1
headline(0.1234, 0.4321)
headline(0.1234, 0.4321, n_decimal = 3)
# or use a multiplier
headline(0.1234, 0.4321, multiplier = 100)

# there are many components you can assemble
headline(
  x = 16,
  y = 8,
  headline = "there was {article_delta_p}\% {trend}, \\\\
  {add_article(trend)} of {delta} ({orig_values})"
)


# compare_conditions() produces a one-row data frame that can be
# passed to headline_list()
pixar_films |>
  compare_conditions(
    x = (rating == "G"),
    y = (rating == "PG"),
    rotten_tomatoes
  ) |>
  headline_list(
    headline = "On average, G-rated films score {delta} points {trend} than \\\\
    PG films on Rotten Tomatoes",
    trend_phrases = trend_terms(more = "higher", less = "lower")
  )

# if you have more than 2 list items, you can specify them by name
list(
  x = 1,
  y = 2,
  z = 3
 ) |>
  headline_list(
    x = x,
    y = z
  )
}
\seealso{
\code{\link[=compare_values]{compare_values()}}, \code{\link[=trend_terms]{trend_terms()}}, and \code{\link[=add_article]{add_article()}}
}
