% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-kmeans.R
\name{assignClusterLabels}
\alias{assignClusterLabels}
\title{Assign labels to the kmeans confusion matrix}
\usage{
assignClusterLabels(cm)
}
\arguments{
\item{cm}{A square dataframe that holds a confusion matrix.
Rownames must correspond to correct labels.}
}
\value{
A character vector of the label names.
}
\description{
Finds the correct label for a the kmeans confusion matrix. This function
assumes that the most populated cluster is the correct one for a given label.
}
\examples{
data(iris)
head(iris)
kmeans.fit <- kmeans(iris[,1:4],3) 
labs <- iris[,5]
cls <- kmeans.fit[["cluster"]]
cm <- calculateConfusion(labels = labs, clusters = cls)
assignClusterLabels(cm)

}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
