% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\alias{evaluate.predicted_df}
\alias{evaluate.model_list}
\title{Get model performance metrics}
\usage{
evaluate(x, ...)

\method{evaluate}{predicted_df}(x, ...)

\method{evaluate}{model_list}(x, ...)
}
\arguments{
\item{x}{Object to be evaluted}

\item{...}{Not used}
}
\description{
Get model performance metrics
}
\details{
This function gets model performance from a model_list object that
  comes from \code{\link{machine_learn}}, \code{\link{tune_models}},
  \code{\link{flash_models}}, or a data frame of predictions from
  \code{\link{predict.model_list}}. For the latter, the data passed to
  \code{predict.model_list} must contain observed outcomes. If you have
  predictions and outcomes in a different format, see
  \code{\link{evaluate_classification}} or \code{\link{evaluate_regression}}
  instead.

  You may notice that \code{evaluate(models)} and
  \code{evaluate(predict(models))} return slightly different performance
  metrics, even though they are being calculated on the same (out-of-fold)
  predictions. This is because metrics in training (returned from
  \code{evaluate(models)}) are calculated within each cross-validation fold
  and then averaged, while metrics calculated on the prediction data frame
  (\code{evaluate(predict(models))}) are calculated once on all observations.
}
\examples{
models <- machine_learn(pima_diabetes[1:40, ],
                        patient_id,
                        outcome = diabetes,
                        models = "rf",
                        tune_depth = 3)
evaluate(models)
predictions <- predict(models, newdata = pima_diabetes[41:50, ])
evaluate(predictions)
}
