% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_importance.R
\name{get_variable_importance}
\alias{get_variable_importance}
\title{Get variable importances}
\usage{
get_variable_importance(models, remove_zeros = TRUE, top_n)
}
\arguments{
\item{models}{model_list object}

\item{remove_zeros}{Remove features with zero variable importance? Default is
TRUE}

\item{top_n}{Integer: How many variables to return? The top_n most important
variables be returned. If missing (default), all variables are returned}
}
\value{
Data frame of variables and their importance for predictive power
}
\description{
Get variable importances
}
\details{
Some algorithms provide variable importance, others don't. The
  best-performing model that offers variable importance will be used.
}
\examples{
m <- machine_learn(mtcars, outcome = mpg, models = "rf", tune = FALSE)
(vi <- get_variable_importance(m))
plot(vi)
}
\seealso{
\code{\link{plot.variable_importance}}
}
