% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmean-funcs.R
\name{hai_kmeans_scree_data_tbl}
\alias{hai_kmeans_scree_data_tbl}
\alias{kmeans_scree_data_tbl}
\title{K-Means Scree Plot Data Table}
\usage{
hai_kmeans_scree_data_tbl(.data)

kmeans_scree_data_tbl(.data)
}
\arguments{
\item{.data}{You must have a tibble in the working environment from the
\code{\link[=hai_kmeans_mapped_tbl]{hai_kmeans_mapped_tbl()}}}
}
\value{
A nested tibble
}
\description{
Take data from the \code{\link[=hai_kmeans_mapped_tbl]{hai_kmeans_mapped_tbl()}} and unnest it into a
tibble for inspection and for use in the \code{\link[=hai_kmeans_scree_plt]{hai_kmeans_scree_plt()}} function.
}
\details{
Takes in a single parameter of .data from \code{\link[=hai_kmeans_mapped_tbl]{hai_kmeans_mapped_tbl()}} and
transforms it into a tibble that is used for \code{\link[=hai_kmeans_scree_plt]{hai_kmeans_scree_plt()}}. It will
show the values (tot.withinss) at each center.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  filter(payer_grouping != "Medicare B") \%>\%
  filter(payer_grouping != "?") \%>\%
  select(service_line, payer_grouping) \%>\%
  mutate(record = 1) \%>\%
  as_tibble()

ui_tbl <- hai_kmeans_user_item_tbl(
  .data = data_tbl,
  .row_input = service_line,
  .col_input = payer_grouping,
  .record_input = record
)

kmm_tbl <- hai_kmeans_mapped_tbl(ui_tbl)

hai_kmeans_scree_data_tbl(kmm_tbl)

}
\seealso{
Other Kmeans: 
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_tidy_tbl}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
