% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-hai-polynomial.R
\name{hai_polynomial_augment}
\alias{hai_polynomial_augment}
\title{Augment Polynomial Features}
\usage{
hai_polynomial_augment(
  .data,
  .formula = NULL,
  .pred_col = NULL,
  .degree = 1,
  .new_col_prefix = "nt_"
)
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.formula}{This should be a valid formula like 'y ~ .^2' or NULL.}

\item{.pred_col}{This is passed \code{\link[rlang:nse-defuse]{rlang::enquo()}} to capture the vector that you
designate as the 'y' column.}

\item{.degree}{This should be an integer and is used to set the degree in the
poly function. The degree must be less than the unique data points or it will
error out.}

\item{.new_col_prefix}{The default is "nt_" which stands for "new_term". You can
set this to whatever you like, as long as it is a quoted string.}
}
\value{
An augmented tibble
}
\description{
This function takes in a data table and a predictor column. A user can either create
their own formula using the \code{.formula} parameter or, if they leave the default of
\code{NULL} then the user must enter a \code{.degree} \strong{AND} \code{.pred_col} column.
}
\details{
A valid data.frame/tibble must be passed to this function. It is required that
a user either enter a \code{.formula} or a \code{.degree} \strong{AND} \code{.pred_col} otherwise this
function will stop and error out.

Under the hood this function will create a \code{\link[stats:poly]{stats::poly()}} function if the
\code{.formula} is left as \code{NULL}. For example:
\itemize{
\item .formula = A ~ .^2
\item OR .degree = 2, .pred_col = A
}

There is also a parameter \code{.new_col_prefix} which will add a character string
to the column names so that they are easily identified further down the line.
The default is 'nt_'
}
\examples{
suppressPackageStartupMessages(library(dplyr))
data_tbl <- data.frame(
  A = c(0,2,4),
  B = c(1,3,5),
  C = c(2,4,6)
)

hai_polynomial_augment(.data = data_tbl, .pred_col = A, .degree = 2, .new_col_prefix = "n")
hai_polynomial_augment(.data = data_tbl, .formula = A ~ .^2, .degree = 1)

}
\seealso{
Other Augment Function: 
\code{\link{hai_fourier_augment}()},
\code{\link{hai_fourier_discrete_augment}()},
\code{\link{hai_hyperbolic_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
