% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-kmeans-predict.R
\name{hai_kmeans_automl_predict}
\alias{hai_kmeans_automl_predict}
\title{Automatic K-Means H2O}
\usage{
hai_kmeans_automl_predict(.input)
}
\arguments{
\item{.input}{This is the output of the \code{\link[=hai_kmeans_automl]{hai_kmeans_automl()}} function.}
}
\value{
A list object
}
\description{
This is a wrapper around the \code{\link[h2o:h2o.predict]{h2o::h2o.predict()}} function that will return a list
object with a lot of useful and easy to use tidy style information.
}
\details{
This function will internally take in the output assigned from the
\code{\link[=hai_kmeans_automl]{hai_kmeans_automl()}} function only and return a list of useful
information. The items that are returned are as follows:
\enumerate{
\item prediction - The h2o dataframe of predictions
\item prediction_tbl - The h2o predictions in tibble format
\item valid_tbl - The validation data in tibble format
\item pred_full_tbl - The entire validation set with the predictions attached using
\code{\link[base:cbind]{base::cbind()}}. The predictions are in a column called \code{predicted_cluster} and
are in the formate of a factor using \code{\link[forcats:as_factor]{forcats::as_factor()}}
}
}
\examples{
\dontrun{
h2o.init()

output <- hai_kmeans_automl(
    .data = iris,
    .predictors = c("Sepal.Width","Sepal.Length","Petal.Width","Petal.Length"),
    .standardize = FALSE
)

pred <- hai_kmeans_automl_predict(output)

h2o.shutdown()
}

}
\seealso{
Other Kmeans: 
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_tidy_tbl}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
