% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clim_spread.R
\name{clim_spread}
\alias{clim_spread}
\title{Spead a time series wide to allow for a climatology to be calculated.}
\usage{
clim_spread(data, clim_start, clim_end, windowHalfWidth)
}
\arguments{
\item{data}{The data given to this function during the calculations
performed by \code{\link{ts2clm}}.}

\item{clim_start}{The first day of the time series to use when spreading.}

\item{clim_end}{The last day of the time series to use when spreading.}

\item{windowHalfWidth}{The width of the smoothing window to be applied.
This width is doubled and centred around the point that the smoothing
occurs. Default = 5, which makes an overall window size of 11.}
}
\value{
The function returns the data (a matrix) in a wide format.
}
\description{
An internal function that helps to create a wide time series that will
then be used by \code{\link{clim_calc}} within \code{\link{ts2clm}}
to produce a climatology as desired by the user.
}
\author{
Smit, A. J.
}
