% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_define.R
\name{define_surv_fit}
\alias{define_surv_fit}
\title{Define a Fitted Survival Model}
\usage{
define_surv_fit(x)
}
\arguments{
\item{x}{a survfit or flexsurvreg object}
}
\value{
A \code{surv_object} object.
}
\description{
Define a fitted survival models with a Kaplan-Meier estimator or
parametric distributions
}
\examples{

library(survival)

define_surv_fit(
  survfit(Surv(time, status) ~ 1, data = colon)
)

define_surv_fit(
  flexsurv::flexsurvreg(Surv(time, status) ~ 1, data = colon, dist = "exp")
)

}
