% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellmer-core.R
\name{process}
\alias{process}
\title{Process batch of prompts with progress tracking and retries}
\usage{
process(
  chat_obj,
  prompts,
  type_spec = NULL,
  judgements = 0,
  state_path = tempfile("chat_", fileext = ".rds"),
  echo = "none",
  max_retries = 3L,
  initial_delay = 1,
  max_delay = 60,
  backoff_factor = 2,
  timeout = 60,
  beep = TRUE
)
}
\arguments{
\item{chat_obj}{Chat model object}

\item{prompts}{List of prompts}

\item{type_spec}{Type specification for structured data}

\item{judgements}{Number of judgements (1 = initial extract + 1 judgement, 2 = initial extract + 2 judgements, etc.)}

\item{state_path}{Path for saving state}

\item{echo}{Echo level}

\item{max_retries}{Maximum retry attempts}

\item{initial_delay}{Initial delay before retry}

\item{max_delay}{Maximum delay between retries}

\item{backoff_factor}{Factor to multiply delay}

\item{timeout}{Maximum time to wait}

\item{beep}{Play sound on completion}
}
\value{
Batch results object
}
\description{
Process batch of prompts with progress tracking and retries
}
\keyword{internal}
