% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{chats}
\alias{chats}
\title{Extract chat objects from a batch result}
\usage{
chats(x, ...)
}
\arguments{
\item{x}{A batch object}

\item{...}{Additional arguments}
}
\value{
A list of chat objects
}
\description{
Extract chat objects from a batch result
}
\examples{
\dontshow{if (ellmer::has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a chat processor
chat <- chat_sequential(chat_openai())

# Process a batch of prompts
batch <- chat$batch(list(
  "What is R?",
  "Explain base R versus tidyverse",
  "Explain vectors, lists, and data frames"
))

# Return the chat objects
batch$chats()
\dontshow{\}) # examplesIf}
}
