% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{HERE Geocoder API: Geocode}
\usage{
geocode(address, sf = TRUE, url_only = FALSE, addresses)
}
\arguments{
\item{address}{character, addresses to geocode.}

\item{sf}{boolean, return an \code{sf} object (\code{default = TRUE}) or a
\code{data.frame}?}

\item{url_only}{boolean, only return the generated URLs (\code{default =
FALSE})?}

\item{addresses}{character, addresses to geocode (deprecated).}
}
\value{
If \code{sf = TRUE}, an \code{sf} object, containing the position coordinates
geocoded addresses as geometry list column and the access coordinates as
well-known text (WKT).
If \code{sf = FALSE}, a \code{data.frame} containing the coordinates of the
geocoded addresses as \code{lng}, \code{lat} columns.
}
\description{
Geocodes addresses using the HERE 'Geocoder' API.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

locs <- geocode(address = poi$city, url_only = TRUE)
}
\references{
\href{https://developer.here.com/documentation/geocoding-search-api/dev_guide/topics/endpoint-geocode-brief.html}{HERE Geocoder API: Geocode}
}
