% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hero.R, R/hero.prepared_array.R,
%   R/hero.prepared_list.R, R/hero.prepared_matrix.R, R/hero.prepared_numeric.R,
%   R/hero.prepared_starray.R, R/hero.prepared_sts.R
\name{hero}
\alias{hero}
\alias{hero.prepared_array}
\alias{hero.prepared_list}
\alias{hero.prepared_matrix}
\alias{hero.prepared_numeric}
\alias{hero.prepared_starray}
\alias{hero.prepared_sts}
\title{Construct a hero sandwich smoother}
\usage{
hero(x, ...)

\method{hero}{prepared_array}(x, ...)

\method{hero}{prepared_list}(x, ...)

\method{hero}{prepared_matrix}(x, ...)

\method{hero}{prepared_numeric}(x, ...)

\method{hero}{prepared_starray}(x, ...)

\method{hero}{prepared_sts}(x, ...)
}
\arguments{
\item{x}{Data prepared via the \code{\link{prepare}}
function.}

\item{...}{Mostly not implemented.  \code{hero.prepared_list} takes
the \code{fitted} argument, specifying whether the \code{fitted}
values should be returned.}
}
\value{
A \code{hero} object with the smoothed data
  (\code{fitted}), the estimated coefficients for the
  basis functions (\code{coefficients}), and the
  locations of the original data (\code{x}).
}
\description{
\code{hero} constructs a hero sandwich smoother based off
off a prepared data object coming from the
\code{\link{prepare}} function.  \cr
Subclasses are added (e.g., \code{hero_numeric},
\code{hero_matrix}, \code{hero_array}, etc.) are added to
the returned object for plotting purposes.
\cr
A list is returned (and the data locations are not) for
\code{hero.prepared_list}.  Each element of the list
contains the coefficients and fitted values (if \code{fitted} is
TRUE) for the respective data observation.
}
\examples{
# create b-splines
x1 = bspline(nbasis = 10)
x2 = bspline(nbasis = 12)

# observed data locations
evalarg1 = seq(0, 1, len = 60)
evalarg2 = seq(0, 1, len = 80)

# construct "true" data
mu = matrix(0, nrow = 60, ncol = 80)
for(i in seq_len(60)) {
   for(j in seq_len(80)) {
      mu[i, j] =  sin(2*pi*(evalarg1[i]-.5)^3)*cos(4*pi*evalarg2[j])
   }
}
# construct noisy data
data = mu + rnorm(60 * 80)

obj = prepare(data, list(evalarg1, evalarg2), list(x1, x2))
obj = enhance(obj)
sandmod = hero(obj)
plot(sandmod)
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\author{
Joshua French.
}
