% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cea.R
\name{incr_effect}
\alias{incr_effect}
\title{Incremental treatment effect}
\usage{
incr_effect(x, comparator, sim, strategy, grp, outcomes)
}
\arguments{
\item{x}{Matrix containing information on outcome variables for each simulation and strategy.}

\item{comparator}{Name of comparator strategy.}

\item{sim}{Name of column denoting simulation number.}

\item{strategy}{Name of column denoting treatment strategy.}

\item{grp}{Name of column denoting subgroup.}

\item{outcomes}{Name of columns to calculate incremental changes for.}
}
\value{
A data.table containing the differences in the values of each variable 
specified in outcomes between each treatment strategy and the 
comparator. It is the same output generated
in \code{delta} from \code{icea_pw}.
}
\description{
Calculate incremental effect of all treatment strategies on outcome variables from 
probabilistic sensitivity analysis relative to comparator.
}
\examples{
# simulation output
nsims <- 100
sim <- data.frame(sim = rep(seq(nsims), 4),
             c = c(rlnorm(nsims, 5, .1), rlnorm(nsims, 5, .1),
                    rlnorm(nsims, 11, .1), rlnorm(nsims, 11, .1)),
             e = c(rnorm(nsims, 8, .2), rnorm(nsims, 8.5, .1),
                   rnorm(nsims, 11, .6), rnorm(nsims, 11.5, .6)),
             strategy = rep(paste0("Strategy ", seq(1, 2)),
                           each = nsims * 2),
             grp = rep(rep(c("Group 1", "Group 2"),
                           each = nsims), 2)
)
# calculate incremental effect of Strategy 2 relative to Strategy 1 by group
incr.effect <- incr_effect(sim, comparator = "Strategy 1", sim = "sim",
                        strategy = "strategy", grp = "grp", outcomes = c("c", "e"))
head(incr.effect)
}
