% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{weibullNMA}
\alias{weibullNMA}
\alias{dweibullNMA}
\alias{pweibullNMA}
\alias{qweibullNMA}
\alias{rweibullNMA}
\alias{hweibullNMA}
\alias{HweibullNMA}
\alias{rmst_weibullNMA}
\alias{mean_weibullNMA}
\title{Parameterization of the Weibull distribution for network meta-analysis}
\usage{
dweibullNMA(x, a0, a1 = FALSE, log = FALSE)

pweibullNMA(q, a0, a1, lower.tail = TRUE, log.p = FALSE)

qweibullNMA(p, a0, a1, lower.tail = TRUE, log.p = FALSE)

rweibullNMA(n, a0, a1)

hweibullNMA(n, a0, a1, log = FALSE)

HweibullNMA(n, a0, a1, log = FALSE)

rmst_weibullNMA(t, a0, a1, start = 0)

mean_weibullNMA(a0, a1)
}
\arguments{
\item{x, q}{Vector of quantiles}

\item{a0}{Intercept of reparameterization of the Weibull distribution.}

\item{a1}{Slope of the reparameterization of the Weibull distribution.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X
\le x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}

\item{p}{Vector of probabilities}

\item{n}{Number of observations. If \code{length(n) > 1}, the length is
taken to be the number required.}

\item{t}{Vector of times for which restricted mean survival time is evaluated.}

\item{start}{Optional left-truncation time or times. The returned restricted
mean survival will be conditional on survival up to this time.}

\item{...}{Additional arguments to pass to random sampling functions.}
}
\value{
\code{dweibullNMA} gives the density, \code{pweibullNMA} gives the
distribution function, \code{qweibullNMA} gives the quantile function,
\code{rweibullNMA} generates random deviates, \code{HweibullNMA} returns the
cumulative hazard and \code{hweibullNMA} the hazard.
}
\description{
Density, distribution function, hazards, quantile function and random generation
for the Weibull distribution when parameterized for network meta-analysis.
}
\seealso{
\code{\link{dweibull}}
}
