% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crnGP.R
\name{simul}
\alias{simul}
\title{Conditional simulation for CRNGP}
\usage{
simul(object, Xgrid, ids, nsim, eps, seqseeds, check)
}
\arguments{
\item{object}{\code{CRNGP} model}

\item{Xgrid}{matrix of (x, seed) locations where the simulation is performed. 
Where all design locations are matched with all seed values. In particular, it is assumed that each unique x values is matched with all seeds before going to the next x value.
The last column MUST correspond to seeds values. \code{Xgrid} must also contain the evaluated designs (e.g., in model$X0)}

\item{ids}{vector of indices corresponding to observed values in \code{Xgrid}}

\item{nsim}{number of simulations to return}

\item{eps}{jitter used in the Cholesky decomposition of the covariance matrix for numerical stability}

\item{seqseeds}{is the seed sequence repeated (e.g., 1 2 3 1 2 3), else it is assumed to be ordered (e.g., 1 1 2 2 3 3)}

\item{check}{if \code{TRUE}, check that Xgrid has the proper structure (slower)}
}
\value{
Conditional simulation matrix.
}
\description{
Conditional simulation for CRNGP
}
