% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cue_validity.R
\name{cueValidityComplete}
\alias{cueValidityComplete}
\title{Calculate cue validity with reverse, cue directions, and cue ranks.}
\usage{
cueValidityComplete(data, criterion_col, cols_to_fit, replaceNanWith = 0.5,
  reverse_cues = FALSE, ties.method = "random")
}
\arguments{
\item{data}{The matrix or data.frame whose columns are treated as cues.}

\item{criterion_col}{The index of the column used as criterion.}

\item{cols_to_fit}{A vector of indexes of the columns to calculate cue
validity for.}

\item{replaceNanWith}{The value to return as cue validity in case it
cannot be calculated.}

\item{reverse_cues}{Optional parameter to reverse cues as needed.  By
default, the model will reverse the cue values for cues with cue validity
< 0.5, so a cue with validity 0 becomes a cue with validity 1.
Set this to FALSE if you do not want that, i.e. the cue stays validity 0.}

\item{ties.method}{An optional parameter passed to rank: A character string
sepcifying how ties (in cue validity) are treated.}
}
\value{
A list where $cue_validities has a vector of validities for
  each of the columns in cols_to_fit.
}
\description{
This provides a vector of cue_validities and potentially other useufl
information, particularly if reverse_cues=TRUE.  For example, education
is negatively associated with number of felonies.  If reverse_cues=FALSE,
education will get validity < 0.5.  If reverse_cues=TRUE, then LESS
education will be used as a predictor, resulting in:
1) cue_validity > 0.5
2) cue_direction == -1
To use the cue for prediction, be sure to multiply it by the cue_direction.
For ranking, based heuristics, cue_ranks gives the rank order of cues where
highest validity = rank 1 (after reversing, if any).
}
\references{
Wikipedia's entry on
\url{https://en.wikipedia.org/wiki/Cue_validity}
}

