% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_pair_apply.R
\name{rowPairApplyList}
\alias{rowPairApplyList}
\title{Apply list of functions to all row pairs.}
\usage{
rowPairApplyList(test_data, function_creator_list,
  also_reverse_row_pairs = FALSE)
}
\arguments{
\item{test_data}{The data to apply the functions to as a matrix or
data.frame.  Heuristics must have already been fitted to trying data and
must include the same criterion_col and cols_to_fit.}

\item{function_creator_list}{List of the functions that generate the
functions to apply, such as heuristics(ttb) and correctGreater(col).}

\item{also_reverse_row_pairs}{Optional parameter.  When it has its default
value of FALSE, it will apply every function only once to any given row
pair, e.g. myFunction(row1, row2).  When it is true, it will also apply
the function to every reverse row pair, e.g. myFunction(row2, row1).}
}
\value{
A matrix of outputs from the functions.  The number of rows is based
  on the number of row pairs in test_data.  If the input has N rows, the
  output will have N x (N-1) rows.  The number of columns will be at least
  the number of functions but may be more as some functions may output more
  than one column.
}
\description{
Apply a list of functions like heuristic predictions to all row pairs in a
matrix or data.frame.  This does not accept arbitrary functions-- they must
be functions designed to be run by rowPairApply.
}
\examples{
# This function is called like 
# rowPairApplyList(data, list(heuristics(ttb, reg)))
# instead of
# rowPairApply(data, heuristics(ttb, reg))
# See rowPairApply for details.

}
\seealso{
\code{\link{rowPairApply}} for no need to use a list.  Examples and details
  are there.
}

