% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_type_lifecycle.R
\name{dependency_type_lifecycle}
\alias{dependency_type_lifecycle}
\title{Dependency type based on time intervals}
\usage{
dependency_type_lifecycle(
  threshold_dependency = 0.9,
  threshold_l1 = threshold_dependency,
  threshold_frequency = 0,
  all_connected = FALSE,
  endpoints_connected = FALSE
)
}
\arguments{
\item{threshold_dependency}{A dependency threshold, usually in the interval \verb{[0,1]}, filtering out dependencies below the threshold.}

\item{threshold_l1}{A dependency threshold, usually in the interval \verb{[0,1]}, filtering out self-loop dependencies below the threshold.}

\item{threshold_frequency}{An absolute frequency threshold filtering dependencies which are observed infrequently.}

\item{all_connected}{If \code{TRUE} the best antecedent and consequent (as determined by the dependency measure) are going to be added regardless of the \code{threshold} value.}

\item{endpoints_connected}{If \code{TRUE} the start/end activity is added as antecedent/consequent when an activity would not be connected according to the \code{threshold} value.}
}
\value{
A dependency type.
}
\description{
Computes the dependencies based on the approach taking into account activity durations based on life-cycle transitions.
}
\examples{
dependency_matrix(L_heur_1,
                  dependency_type = dependency_type_fhm(all_connected = TRUE))

}
\references{
A. Burattin and A. Sperduti, “Heuristics Miner for Time Intervals,” in ESANN 2010, 18th European Symposium on Artificial Neural Networks, Bruges, Belgium, April 28-30, 2010, Proceedings, 2010.
}
