% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_matrix.R
\name{dependency_matrix}
\alias{dependency_matrix}
\title{Create a dependency matrix}
\usage{
dependency_matrix(
  eventlog = NULL,
  dependency_type = dependency_type_fhm(threshold_dependency = threshold,
    threshold_frequency = threshold_frequency, ...),
  threshold = 0.9,
  threshold_frequency = 0,
  ...
)
}
\arguments{
\item{eventlog}{A bupaR event log, may be NULL when a precedence matrix is provided.}

\item{dependency_type}{Which approach to use for calculation of the dependency matrix. Currently only (\code{\link{dependency_type_fhm}}) is available.}

\item{threshold}{A dependency threshold, usually in the interval \verb{[0,1]}, filtering out dependencies below the threshold.}

\item{threshold_frequency}{An absolute frequency threshold filtering dependencies which are observed infrequently.}

\item{...}{Parameters forwarded to (\code{\link{dependency_type_fhm}}).}
}
\value{
A square matrix with class \code{dependency_matrix} containing the computed dependency values between all activities.
}
\description{
Creates a dependency matrix from a precedence matrix (\code{\link{precedence_matrix}}) based on different approaches.
}
\examples{
d <- dependency_matrix(L_heur_1)
print(d)
as.matrix(d)

}
\seealso{
\code{\link{precedence_matrix}}
}
