% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.hfr.R
\name{predict.cv.hfr}
\alias{predict.cv.hfr}
\title{Model predictions}
\usage{
\method{predict}{cv.hfr}(object, newdata = NULL, kappa = NULL, ...)
}
\arguments{
\item{object}{Fitted 'cv.hfr' model.}

\item{newdata}{Matrix or data.frame of new values for \code{x} at which predictions are to be made.}

\item{kappa}{The hyperparameter used for prediction. If empty, the optimal value is used.}

\item{...}{additional methods passed to \code{predict}.}
}
\value{
A vector of predicted values.
}
\description{
Predict values using a fitted \code{cv.hfr} model
}
\details{
Predictions are made by multiplying the \code{newdata} object with the estimated coefficients.
The chosen hyperparameter value to use for predictions can be passed to
the \code{kappa} argument.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = cv.hfr(x, y, kappa = seq(0, 1, by = 0.1))
predict(fit, kappa = 0.1)

}
\seealso{
\code{\link{hfr}}, \code{\link{cv.hfr}} and \code{\link{coef}} methods
}
\author{
Johann Pfitzinger
}
