% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateCountsArray.R
\name{aggregateCountsArray}
\alias{aggregateCountsArray}
\title{Aggregate an Array of Counts wrt One Dimension (Stratum)}
\usage{
aggregateCountsArray(counts, dim, grouping, ..., sort = TRUE)
}
\arguments{
\item{counts}{an (integer) array of counts with \code{dimnames},
e.g., \code{\link{counts}} or \code{\link{pop2011}}.}

\item{dim}{the dimension index of the stratum defining groups.}

\item{grouping, ...}{how the groups should be built.}

\item{sort}{logical indicating if the resulting array should be ordered
by the grouping levels in the \code{dim} dimension.}
}
\value{
an array with similar dimensions as the input \code{counts}
except for the \code{dim} dimension, which will be smaller due to the
aggregation as specified by the \code{grouping} argument.
}
\description{
Aggregate an Array of Counts wrt One Dimension (Stratum)
}
\examples{
## works for matrices
aggregateCountsArray(pop2011, dim = 2, grouping = c(2,1,3,2,4))
aggregateCountsArray(pop2011, dim = 1, grouping = list(
    "a" = c("chwi","span","zehl"),
    "b" = c("neuk","scho")
))
## and of course for arrays
str(aggregateCountsArray(counts, dim = 3, grouping = c(1, 3, 4)))
}
\author{
Sebastian Meyer
}
\keyword{manip}
