% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerC.R
\name{powerC}
\alias{powerC}
\alias{make_powerC}
\title{Exponentiate a Matrix via Eigendecomposition}
\usage{
make_powerC(C, normalize = FALSE, truncate = FALSE)
}
\arguments{
\item{C}{a square numeric matrix.}

\item{normalize}{a logical indicating if \code{C} should be normalized
in advance such that all rows sum to 1 (becomes a transition matrix).}

\item{truncate}{a logical indicating whether to force entries in the
resulting matrix to be non-negative (by truncation at 0).}
}
\value{
a function of the \code{power}
that returns the exponentiated matrix.
}
\description{
Based on a (contact) matrix \code{C}, the function \code{make_powerC}
generates a function with a single argument \code{power} that returns
the input matrix raised to that power. Matrix exponentiation is thereby
defined via the eigendecomposition of \code{C} as
\eqn{C^{power} := E \Lambda^{power} E^{-1}}.
}
\examples{
Cnorm <- contactmatrix(normalize = TRUE)
powerC <- make_powerC(Cnorm)
powerC(1)
powerC(0)
powers <- c(0, 0.5, 1, 2)
Cp <- lapply(powers, powerC)
if (require("gridExtra"))
    grid.arrange(
        grobs = mapply(plotC, C = Cp, main = paste("power =", powers),
                       SIMPLIFY = FALSE),
        nrow = 2, ncol = 2)

## truncation to enforce non-negative entries
powerC(0.2)  # some entries become negative for small powers
powerC0 <- make_powerC(Cnorm, truncate = TRUE)
powerC0(0.2)
}
