% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rHYCov}
\alias{rHYCov}
\title{Hayashi-Yoshida Covariance}
\usage{
rHYCov(
  rdata,
  cor = FALSE,
  period = 1,
  align.by = "seconds",
  align.period = 1,
  makeReturns = FALSE,
  makePsd = TRUE
)
}
\arguments{
\item{rdata}{a possibly multivariate xts object.}

\item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{period}{Sampling period}

\item{align.by}{Align the tick data to seconds|minutes|hours}

\item{align.period}{Align the tick data to this many [seconds|minutes|hours]}

\item{makeReturns}{Prices are passed make them into log returns}

\item{makePsd}{boolean, in case it is TRUE, the positive definite version of rHYCov is returned. FALSE by default.}
}
\description{
Calculates the Hayashi-Yoshida Covariance estimator
}
\references{
T. Hayashi and N. Yoshida. On covariance estimation of non-synchronously observed diffusion processes. \emph{Bernoulli}, 11, 359-379, 2005.
}
\author{
Scott Payseur

# Average Hayashi-Yoshida Covariance estimator is calculated on five-minute returns

# Multivariate:
# realized_cov <- rHYCov(rdata = cbind(lltc, sbux, fill = 0), period = 5, align.by = "minutes", 
#                        align.period = 5, makeReturns = FALSE)
# realized_cov 
Note: for the diagonal elements the rCov is used.
}
\keyword{volatility}
