% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jumpTests.R
\name{AJjumpTest}
\alias{AJjumpTest}
\title{Ait-Sahalia and Jacod (2009) tests for the presence of jumps in the price series.}
\usage{
AJjumpTest(
  pData,
  p = 4,
  k = 2,
  alignBy = NULL,
  alignPeriod = NULL,
  alphaMultiplier = 4,
  alpha = 0.975,
  ...
)
}
\arguments{
\item{pData}{either an \code{xts} or a \code{data.table} containing the prices of a single asset, possibly over multiple days.}

\item{p}{can be chosen among 2 or 3 or 4. The author suggests 4. 4 by default.}

\item{k}{can be chosen among 2 or 3 or 4. The author suggests 2. 2 by default.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}.
To aggregate based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to "minutes".}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5 minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{alphaMultiplier}{alpha multiplier}

\item{alpha}{numeric of length one with the significance level to use for the jump test(s). Defaults to 0.975.}

\item{...}{used internally}
}
\value{
a list or \code{xts} in depending on whether input prices span more than one day.
}
\description{
This test examines the presence of jumps in highfrequency price series. It is based on the theory of Ait-Sahalia and Jacod (2009). 
It consists in comparing the multi-power variation of equi-spaced returns computed at a fast time scale (\eqn{h}), \eqn{r_{t,i}} (\eqn{i=1, \ldots,N}) and those computed at the slower time scale (\eqn{kh}), \eqn{y_{t,i}}(\eqn{i=1, \ldots ,\mbox{N/k}}).

They found that the limit (for \eqn{N} \eqn{\to} \eqn{\infty} ) of the realized power variation is invariant for different sampling scales and that their ratio is \eqn{1} in case of jumps and \eqn{\mbox{k}^{p/2}-1} if no jumps.
Therefore the AJ test detects the presence of jump using the ratio of realized power variation sampled from two scales. The null hypothesis is no jumps.

The function returns three outcomes: 1.z-test value 2.critical value under confidence level of \eqn{95\%} and 3. \eqn{p}-value.

Assume there is \eqn{N} equispaced returns in period \eqn{t}. Let \eqn{r_{t,i}} be a return (with \eqn{i=1, \ldots,N}) in period \eqn{t}.

And there is \eqn{N/k} equispaced returns in period \eqn{t}. Let \eqn{y_{t,i}} be a return (with \eqn{i=1, \ldots ,\mbox{N/k}}) in period \eqn{t}.

 Then the AJjumpTest is given by: 
   \deqn{
     \mbox{AJjumpTest}_{t,N}= \frac{S_t(p,k,h)-k^{p/2-1}}{\sqrt{V_{t,N}}}
   }
 
 in which, 
 
 \deqn{
   \mbox{S}_t(p,k,h)= \frac{PV_{t,M}(p,kh)}{PV_{t,M}(p,h)}
 }
 
 \deqn{
   \mbox{PV}_{t,N}(p,kh)= \sum_{i=1}^{N/k}{|y_{t,i}|^p}
 }
 
 \deqn{
   \mbox{PV}_{t,N}(p,h)= \sum_{i=1}^{N}{|r_{t,i}|^p}
 }
 
 \deqn{
   \mbox{V}_{t,N}= \frac{N(p,k) A_{t,N(2p)}}{N A_{t,N(p)}}
 }
 
 \deqn{
   \mbox{N}(p,k)= \left(\frac{1}{\mu_p^2}\right)(k^{p-2}(1+k))\mu_{2p} + k^{p-2}(k-1) \mu_p^2 - 2k^{p/2-1}\mu_{k,p}
 }
 
 \deqn{
   \mbox{A}_{t,n(2p)}= \frac{(1/N)^{(1-p/2)}}{\mu_p} \sum_{i=1}^{N}{|r_{t,i}|^p} \ \ \mbox{for} \ \ |r_j|< \alpha(1/N)^w
 }
 
 \deqn{
   \mu_{k,p}=  E(|U|^p  |U+\sqrt{k-1}V|^p)
 } 
 
 \eqn{U, V}: independent standard normal random variables; \eqn{h=1/N}; \eqn{p, k, \alpha, w}: parameters.
}
\details{
The theoretical framework underlying jump test is that the logarithmic price process \eqn{X_t} belongs to the class of Brownian semimartingales, which can be written as:
   \deqn{
     \mbox{X}_{t}=  \int_{0}^{t} a_udu + \int_{0}^{t}\sigma_{u}dW_{u} + Z_t
   }
 where \eqn{a} is the drift term, \eqn{\sigma} denotes the spot volatility process, \eqn{W} is a standard Brownian motion and \eqn{Z} is a jump process defined by:
   \deqn{
     \mbox{Z}_{t}=  \sum_{j=1}^{N_t}k_j
   }
 where \eqn{k_j} are nonzero random variables. The counting process can be either finite or infinite for finite or infinite activity jumps.
 
Using the convergence properties of power variation and its dependence on the time scale on which it is measured, 
Ait-Sahalia and Jacod (2009) define a new variable which converges to 1 in the presence of jumps in the underlying return series, 
or to another deterministic and known number in the absence of jumps (Theodosiou and Zikes, 2009).
}
\examples{
jt <- AJjumpTest(sampleTData[, list(DT, PRICE)], p = 2, k = 3, 
                 alignBy = "seconds", alignPeriod = 5, makeReturns = TRUE)

}
\references{
Ait-Sahalia, Y. and Jacod, J. (2009). Testing for jumps in a discretely observed process. The Annals of Statistics, 37(1), 184-222.

Theodosiou, M., & Zikes, F. (2009). A comprehensive comparison of alternative tests for jumps in asset prices. Unpublished manuscript, Graduate School of Business, Imperial College London.
}
\author{
Giang Nguyen, Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup.
}
\keyword{AJjumpTest}
\keyword{highfrequency}
