% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{gatherPrices}
\alias{gatherPrices}
\title{Make TAQ format}
\usage{
gatherPrices(data)
}
\arguments{
\item{data}{An \code{xts} or a \code{data.table} object with at least \code{"DT"} and d columns with price data with their names corresponding to the respective symbols.}
}
\value{
a \code{data.table} with columns \code{DT}, \code{SYMBOL}, and \code{PRICE}
}
\description{
Convenience function to gather data from one \code{xts} or \code{data.table} 
with at least \code{"DT"}, and d columns containing price data to a \code{"DT"}, \code{"SYMBOL"}, and \code{"PRICE"}
column. This function the opposite of \code{\link{spreadPrices}}.
}
\examples{
\dontrun{
library(data.table)
data1 <- copy(sampleTData)[,  `:=`(PRICE = PRICE * runif(.N, min = 0.99, max = 1.01),
                                               DT = DT + runif(.N, 0.01, 0.02))]
data2 <- copy(sampleTData)[, SYMBOL := 'XYZ']
dat1 <- rbind(data1[, list(DT, SYMBOL, PRICE)], data2[, list(DT, SYMBOL, PRICE)])
setkeyv(dat1, c("DT", "SYMBOL"))
dat1
dat <- spreadPrices(dat1) # Easy to use for realized measures
dat
dat <- gatherPrices(dat)
dat
all.equal(dat1, dat) # We have changed to RM format and back.
}
}
\seealso{
\code{\link{spreadPrices}}
}
\author{
Emil Sjoerup
}
