% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlighted_text.R
\name{highlighted_text}
\alias{highlighted_text}
\title{Create Highlighted Testimony}
\usage{
highlighted_text(plot_object, labels = c("", ""))
}
\arguments{
\item{plot_object}{plot object resulting from \code{\link[=collocation_plot]{collocation_plot()}}}

\item{labels}{lower and upper labels for the gradient scale}
}
\value{
html code for highlighted text
}
\description{
Adds html tags to create a highlighted testimony corresponding to word frequency.
}
\examples{
comment_example_rename <- dplyr::rename(comment_example, page_notes=Notes)
toks_comment <- token_comments(comment_example_rename)
transcript_example_rename <- dplyr::rename(transcript_example, text=Text)
toks_transcript <- token_transcript(transcript_example_rename)
collocation_object <- collocate_comments(toks_transcript, toks_comment)
merged_frequency <- transcript_frequency(transcript_example_rename, collocation_object)
freq_plot <- collocation_plot(merged_frequency)
page_highlight <- highlighted_text(freq_plot, merged_frequency)
}
