% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readpppdata.R
\name{read_pppdata}
\alias{read_pppdata}
\title{Read data, so it can be used for high-risk zone methodology.}
\usage{
read_pppdata(xppp, yppp, xwin = NULL, ywin = NULL, unitname = NULL)
}
\arguments{
\item{xppp}{Vector of x coordinates of data points}

\item{yppp}{Vector of y coordinates of data points}

\item{xwin}{Vector of x coordinates of the vertices of a polygon circumscribing the observation window}

\item{ywin}{Vector of y coordinates of the vertices of a polygon circumscribing the observation window}

\item{unitname}{Optional. Name of unit of length. Either a single character string, or a vector of two 
character strings giving the singular and plural forms, respectively.}
}
\value{
An object of class "ppp" describing a point pattern in the two-dimensional plane.
}
\description{
If xwin or ywin is NULL, the observation window will be a rectangular bounding box.
Vertices must be listed anticlockwise; no vertex should be repeated.
Only needed for data that is not already of class ppp.
}
\examples{
data(craterA)
windowA <- data.frame(x = craterA$window$bdry[[1]]$x, y = craterA$window$bdry[[1]]$y)
patternA <- data.frame(x = craterA$x, y = craterA$y)
str(patternA)
str(windowA)
crater <- read_pppdata(xppp = patternA$x, yppp = patternA$y, 
                       xwin = windowA$x, ywin = windowA$y)
crater
}
\seealso{
\code{\link[spatstat]{ppp}}, \code{\link[spatstat]{bounding.box.xy}}, \code{\link[spatstat]{owin}}
}
