% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilbert.order.R
\name{hilbert.order}
\alias{hilbert.order}
\title{Estimate the Hilbert order for a given matrix}
\usage{
hilbert.order(mat)
}
\arguments{
\item{mat}{the matrix for which to estimate the Hilbert order}
}
\value{
the suggested number of bins to use for the specified \code{mat}.
}
\description{
Estimate the Hilbert order, or the number of bins in each dimension, so that if the matrix was
random every row in the matrix would correspond to a single bin.
}
\details{
Assuming the matrix is fully random, there is no need to generate more voxels
           (the combination of bins over all dimensions) than there are rows in the matrix. The number can be
           derived from the following formula:
           \deqn{c^{d} < N}{c^d < N}
           where \emph{c} is the number of bins, \emph{d} is the number of dimensions and \emph{N} is the total
           number of cells in the dataset. \emph{c} can be computed easily using the following formula:
           \deqn{c = \lfloor \sqrt[d]{N}}{c = floor(N^1/d)}
           The number of cuts for \code{\link{do.cut}} is the number of bins plus 1.
}
\examples{
# generate a random 3D matrix with 2 peaks
mat <- rbind(matrix(rnorm(300),ncol=3),
             matrix(rnorm(300,5,1),ncol=3))
dimnames(mat)[[2]] <- LETTERS[1:3]
# estimate the Hilbert order
hilbert.order(mat)
# generate 2 bins with a minimum bin size of 5
cuts <- make.cut(mat,n=3,count.lim=5)
show.cut(cuts)
# Generate the cuts
cut.mat <- do.cut(mat,cuts,type='fixed')
head(cut.mat)
}
\author{
Yann Abraham
}
