% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.cut.R
\name{show.cut}
\alias{show.cut}
\title{Plot the cuts generated through make.cut}
\usage{
show.cut(cuts, type = "all", local = FALSE)
}
\arguments{
\item{cuts}{the output of the \code{\link{make.cut}}.}

\item{type}{which cuts to show. This must be one of "all", "fixed" or "combined".
Any unambiguous substring can be given.}

\item{local}{defaults to \code{FALSE}; if \code{TRUE}, shows the local minima and maxima as a rug plot.}
}
\value{
the function returns an invisible `NULL`.
}
\description{
Visualize the cuts in relation with the distribution of the data for each dimension
in the original matrix
}
\details{
"fixed" will show \code{n} equally spaced cuts (see \code{\link{make.cut}} for the definition of \code{n}).
           "combined" will show the cuts after adjustment for local minima and maxima.
           "all" will show both. Setting \code{local} to \code{TRUE} will enable the visualization of
           local minima and maxima detected by the algorithm in each dimension.
}
\examples{
# generate a random 3D matrix with 2 peaks
mat <- rbind(matrix(rnorm(300),ncol=3),
             matrix(rnorm(300,5,1),ncol=3))
dimnames(mat)[[2]] <- LETTERS[1:3]
# estimate the Hilbert order
hilbert.order(mat)
# generate 2 bins with a minimum bin size of 5
cuts <- make.cut(mat,n=3,count.lim=5)
show.cut(cuts)
# Generate the cuts
cut.mat <- do.cut(mat,cuts,type='fixed')
head(cut.mat)
}
\author{
Yann Abraham
}
