% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_phylo.R
\name{hill_phylo}
\alias{hill_phylo}
\title{Phylogenetic diversity through Hill Numbers}
\usage{
hill_phylo(comm, tree, q = 0, base = exp(1), rel_then_pool = TRUE,
  show.warning = TRUE)
}
\arguments{
\item{comm}{A data frame of vegtation data. Sites as rows, species as columns.}

\item{tree}{a phylogeny with class 'phylo'.}

\item{q}{Hill number, \code{q} = 0 (default) to get species richness,
\code{q} = 1 to get shannon entropy, \code{q} = 2 will give inverse Simpson.}

\item{base}{default is \code{exp(1)}, the base of log.}

\item{rel_then_pool}{default is \code{TRUE.} Abundance of species are first changed to relative abundance within sites,
then pooled into one assemblage. If \code{FALSE}, sites are pooled first, then change abundance of species
to relative abundance.}

\item{show.warning}{whether to print warning, default is \code{TRUE}.}
}
\value{
A vector of hill number based phylogenetic diversity for all sites.
}
\description{
Calculate alpha phylogenetic diversity based on Hill numbers
}
\examples{
comm = dummy = FD::dummy$abun
tree = ape::rtree(n = ncol(comm), tip.label = paste0('sp', 1:8))
hill_phylo(comm, tree, q = 0)
hill_phylo(comm, tree, q = 0.999)
hill_phylo(comm, tree, q = 1)
hill_phylo(comm, tree, q = 2)

}
\references{
Chao, Anne, Chun-Huo Chiu, and Lou Jost. Unifying Species Diversity, Phylogenetic Diversity, Functional Diversity, and Related Similarity and Differentiation Measures Through Hill Numbers. Annual Review of Ecology, Evolution, and Systematics 45, no. 1 (2014): 297–324. <doi:10.1146/annurev-ecolsys-120213-091540>.
}
\author{
Chiu & Chao
}
