% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth_cov.R
\name{depth_cov}
\alias{depth_cov}
\title{Depth coverage assessment}
\usage{
depth_cov(abund, qvalue)
}
\arguments{
\item{abund}{A vector or a matrix/data.frame indicating the relative abundances of one or multiple samples, respectively. If a matrix/data.frame is provided, columns must refer to samples and rows to OTUs.}

\item{qvalue}{A positive integer or decimal number (>=0), usually between 0 and 3.}
}
\value{
A matrix with observed diversity,  estimated diversities and coverage
}
\description{
Coverage of the estimated Hill numbers at different orders of diversity.
}
\details{
Depth coverage assessment
}
\examples{
data(bat.diet.otutable)
depth_cov(bat.diet.otutable,0)
depth_cov(bat.diet.otutable,qvalue=1)
}
\references{
Chao, A. & Jost, L. (2015) Estimating diversity and entropy profiles via discovery rates of new species. Methods in Ecology and Evolution, 6, 873-882.\cr\cr
Jost, L. (2006). Entropy and diversity. Oikos, 113, 363-375.\cr\cr
Hill, M. O. (1973). Diversity and evenness: a unifying notation and its consequences. Ecology, 54, 427-432.
}
\seealso{
\code{\link{hill_div}}, \code{\link{depth_filt}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{coverage}
\keyword{sequencing}
