% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_sim_mixture.R
\name{hb_sim_mixture}
\alias{hb_sim_mixture}
\title{Non-longitudinal mixture simulations.}
\usage{
hb_sim_mixture(
  n_study = 5,
  n_group = 3,
  n_patient = 100,
  n_continuous = 0,
  n_binary = 0,
  s_delta = 1,
  s_beta = 1,
  s_sigma = 1,
  m_omega = 0,
  s_omega = 1,
  p_omega = 1/n_study,
  alpha = omega[pi],
  delta = stats::rnorm(n = n_group - 1, mean = 0, sd = s_delta),
  beta = stats::rnorm(n = n_continuous + n_binary, mean = 0, sd = s_delta),
  sigma = stats::runif(n = 1, min = 0, max = s_sigma),
  pi = sample.int(n = n_study, size = 1, prob = p_omega),
  omega = stats::rnorm(n = n_study, mean = m_omega, sd = s_omega)
)
}
\arguments{
\item{n_study}{Number of studies to simulate.}

\item{n_group}{Number of groups (e.g. study arms) to simulate per study.}

\item{n_patient}{Number of patients to simulate per study per group.}

\item{n_continuous}{Number of continuous covariates to simulate
(all from independent standard normal distributions).}

\item{n_binary}{Number of binary covariates to simulate
(all from independent Bernoulli distributions with p = 0.5).}

\item{s_delta}{Numeric of length 1, prior standard deviation
of the study-by-group effect parameters \code{delta}.}

\item{s_beta}{Numeric of length 1, prior standard deviation
of the fixed effects \code{beta}.}

\item{s_sigma}{Numeric of length 1, prior upper bound
of the residual standard deviations.}

\item{m_omega}{Numeric of length 1 or \code{n_study},
prior control group mean of each study.
If length \code{n_study},
then the last element corresponds to the current study,
and the others are for historical studies.}

\item{s_omega}{Numeric of length 1 or \code{n_study},
prior control group standard deviation of each study.
If length \code{n_study},
the the last element corresponds to the current study,
and the others are for historical studies.}

\item{p_omega}{Numeric of length \code{n_study},
prior mixture proportion of each study.
If length \code{n_study},
then the last element corresponds to the current study,
and the others are for historical studies.}

\item{alpha}{Numeric vector of length 1 for the pooled
and mixture models and length \code{n_study} for the
independent and hierarchical models.
\code{alpha} is the vector of control group mean parameters.
\code{alpha} enters the model by multiplying with
\verb{$matrices$x_alpha} (see the return value).
The control group in the data is the one with the
\code{group} column equal to 1.}

\item{delta}{Numeric vector of length \code{n_group - 1}
of treatment effect parameters.
\code{delta} enters the model by multiplying with
\verb{$matrices$x_delta} (see the return value).
The control (non-treatment) group in the data is the one with the
\code{group} column equal to 1.}

\item{beta}{Numeric vector of \code{n_continuous + n_binary}
fixed effect parameters.
The first \code{n_continuous} betas
are for the continuous covariates, and the rest are for
the binary covariates.
\code{betas} enters the model by multiplying with
\verb{$matrices$x_alpha} (see the return value).}

\item{sigma}{Numeric vector of \code{n_study} study-specific
residual standard deviations.}

\item{pi}{Integer of length 1,
index of the mixture component randomly
chosen for \code{alpha}.}

\item{omega}{Numeric of length \code{n_study},
Candidate placebo mean parameters
drawn from each of the mixture components.}
}
\value{
A list with the following elements:
\itemize{
\item \code{data}: tidy long-form dataset with the patient-level data.
one row per patient and indicator columns for the study,
group (e.g. treatment arm), and patient ID. The \code{response}
columns is the patient response. The other columns are
baseline covariates. The control group is the one with
the \code{group} column equal to 1, and the current study (non-historical)
is the one with the maximum value of the \code{study} column.
Only the current study has any non-control-group patients,
the historical studies have only the control group.
\item \code{parameters}: named list of model parameter values.
See the model specification vignette for details.
\item \code{matrices}: A named list of model matrices.
See the model specification vignette for details.
}
}
\description{
Simulate from the non-longitudinal mixture model.
}
\examples{
hb_sim_mixture()$data
}
\seealso{
Other simulate: 
\code{\link{hb_sim_hierarchical}()},
\code{\link{hb_sim_independent}()},
\code{\link{hb_sim_pool}()}
}
\concept{simulate}
