% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele-clean.R
\name{CleanAllele}
\alias{CleanAllele}
\title{Clean messy HLA typing data}
\usage{
CleanAllele(var_1, var_2)
}
\arguments{
\item{var_1}{HLA on allele 1.}

\item{var_2}{HLA on allele 2.}
}
\value{
A data frame with 4 columns:
- `var_1`: raw messy input hla, identical with first input
- `var_2`: raw messy input hla, identical with second input
- `locus1_clean`: cleaned hla of var_1
- `locus2_clean`: cleaned hla of var_2
}
\description{
This function takes raw messy HLA(Human Leukocyte Antigen) typing data as input. It removes inconsistent formatting and unnecessary symbols. If one of two alleles at a loci is NA, the locus is assumed to be homozygous.
}
\examples{
dat <-  read.csv(system.file("extdata/example", "HLA_Clean_test.csv", package = "hlaR"))
re <- CleanAllele(dat$recipient_a1, dat$recipient_a2)
}
