% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-02-21.R
\name{hmi_pool}
\alias{hmi_pool}
\title{Averages the results of the imputation function \code{hmi}.}
\usage{
hmi_pool(mids, analysis_function)
}
\arguments{
\item{mids}{A \code{mids} (multiple imputed data set) object.
Either from the \code{hmi} imputation function or \code{mice}.}

\item{analysis_function}{A user generated function that contains the model and the model parameters
he is interested in. See examples.}
}
\value{
A vector with all averaged results.
}
\description{
This function applies the analysis the user is interested in, on all different imputed dataset.
Then the results are pooled by simply averaging the results. So the user has to make sure that
his analysis produces results with a meaningful average. And furthermore has to accept that no
variance is calculated for these parameters.
}
\examples{
\dontrun{
my.formula <- Reaction ~ Days + (1 + Days|Subject)
my_analysis <- function(complete_data){
 # In this list, you can write all the parameters you are interested in.
 # Those will be averaged.
 # So make sure that averaging makes sense and that you only put in single numeric values.
 parameters_of_interest <- list()

 # ---- write in the following lines, what you are interested in to do with your complete_data
 # the following lines are an example where the analyst is interested in the fixed intercept
 # and fixed slope and the random intercepts variance,
 # the random slopes variance and their covariance
 my_model <- lmer(my.formula, data = complete_data)

 parameters_of_interest[[1]] <- fixef(my_model)[1]
 parameters_of_interest[[2]] <- fixef(my_model)[2]
 parameters_of_interest[[3]] <- VarCorr(my_model)[[1]][1, 1]
 parameters_of_interest[[4]] <- VarCorr(my_model)[[1]][1, 2]
 parameters_of_interest[[5]] <- VarCorr(my_model)[[1]][2, 2]
 names(parameters_of_interest) <- c("beta_intercept", "beta_Days", "sigma0", "sigma01", "sigma1")

 # ---- do not change this function below this line.
 return(parameters_of_interest)
}
require("lme4")
require("mice")
data(sleepstudy, package = "lme4")
test <- sleepstudy
test$Intercept <- 1
test[sample(1:nrow(test), size = 20), "Reaction"] <- NA
hmi_imp <- hmi(data = test, model_formula = my.formula, M = 5)
hmi_pool(mids = hmi_imp, analysis_function = my_analysis)
#if you are interested in fixed effects only, consider using \\code{pool} from \\code{mice}.
pool(with(data = hmi_imp, expr = lmer(Reaction ~ Days + (1 + Days | Subject))))
}
require("lme4")
test <- sleepstudy
test$Intercept <- 1
test[sample(1:nrow(test), size = 20), "Reaction"] <- NA
hmi(data = test, model_formula = Reaction ~ Days + (1 + Days|Subject), M = 2, maxit = 1)
}
