% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictor.R
\name{predict.hmlasso}
\alias{predict.hmlasso}
\title{Predict responses}
\usage{
\method{predict}{hmlasso}(object, newx, s = NULL,
  impute_method = "mean", adjust_by_tr = FALSE, ...)
}
\arguments{
\item{object}{hmlasso model}

\item{newx}{matrix of explanatory variables}

\item{s}{selected lambda (default: all)}

\item{impute_method}{imputation method for predictions (default: "mean")}

\item{adjust_by_tr}{whether mean (or median) of training data for prediction is used or not}

\item{...}{parameters of predict function}
}
\description{
Predict responses
}
\examples{
X_incompl <- as.matrix(iris[, 1:3])
X_incompl[1:5,1] <- NA
X_incompl[6:10,2] <- NA
y <- iris[, 4]
cv_fit <- cv.hmlasso(X_incompl, y, nlambda=50, lambda.min.ratio=1e-2)
predict(cv_fit$fit, X_incompl)

}
