% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.hmma.R
\name{simulate.hmma}
\alias{simulate.hmma}
\title{Simulates a HMM-A.}
\usage{
\method{simulate}{hmma}(object, nsim, seed = NULL, ...)
}
\arguments{
\item{object}{A hmma object}

\item{nsim}{An integer or vector of integers (for multiple sequences)
specifying the length of the sequence(s)}

\item{seed}{\code{seed} for the random number generator}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A simulation with the following values \itemize{ \item \code{s} The
  states of the model. \item \code{x} The observations. \item \code{n} The
  length of the observation. }
}
\description{
\code{simulate.hmma} simulates a HMM-A. The only difference between
\code{simulate.hmma} and \code{simulate.hmmspec} is that this function adds
the names of the nodes of the Bayesian networks to the results. The
\code{simulate.hmmspec} function only uses numbers, instead of names.
}
\examples{
# Get a HMM-A (e.g. from learnModel or createHmma)
model <- learnModel(data = hmmaExampleData, amountOfStates = 2, seed = 1234)

# Simulate the data, results in 100 observation sequences of length 20.
data <- simulate(model, nsim = c(rep(20, 100)))

}
