% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMfHMM.R
\name{fitBM_fhmm}
\alias{fitBM_fhmm}
\title{Baum-Welch Function for functional data}
\usage{
fitBM_fhmm(hmm)
}
\arguments{
\item{hmm}{a hmm object obtained from setfHMM}
}
\value{
The function returns all the parameters of a HMM, computed via Baum-Welch algorithm:
the vector of initial probabilities, the transition matrix, the parameters of the distributions
related to the states and the value of the log-likelihood.
}
\description{
This function is based on an EM algorithm (the Baum-Welch algorithm) and computes the parameters of a HMM for functional data, returning an object of \code{S3} class \code{fhmm}.
}
\examples{
\donttest{
data( simulatedFD )
FD <- simulatedFD
n <- 20
n_tot <- dim( FD$data[[1]] )[1]
bt <- seq( 1, n_tot, by = n )
hmm <- set_fhmm( FD, nStates = 4, bT = bt )

bw <- fitBM_fhmm(hmm)}
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Hidden Markov Models for multivariate functional data, MOX Report 21/2019, 2019
}
