% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viterbi.R
\name{viterbi}
\alias{viterbi}
\title{Viterbi Function}
\usage{
viterbi(hmm)
}
\arguments{
\item{hmm}{a hmm object obtained from the setHMM function}
}
\value{
The function returns a vector \code{q} of integers indicating the best state sequence for a HMM
}
\description{
This function computes the best sequence of states for a Hidden Markov Model
}
\examples{
data(copulahmmdata)
Obs <- copulahmmdata
n <- 20 #number of statistical units
n_tot <- dim(Obs)[1]
bt <- seq(1, n_tot, by = n)
distr <- c("exp", "gaussian")
#Initialize the HMM
parameters <- list( as.matrix(c(1,0.25)), matrix(c(3, -1, 1, 1), nrow = 2))
corr <- array(c(1, 0.4, 0.4, 1, 1, 0.1, 0.1, 1), dim = c(2, 2, 2))
hmm <- set_mhmm(Obs, bT = bt, nStates = 2, params = parameters, corr = corr, distr = distr)
# Compute the parameters of the HMM with the Baum-Welch algorithm
bw <- fitBM_mhmm(hmm)

v <- viterbi(bw)
}
\references{
Rabiner, L. R. (1989). A tutorial on hidden Markov models and selected applications in speech recognition. Proceedings of the IEEE, 77(2), 257-286.
}
